<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1><?php echo e($title); ?></h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active"> <?php echo e($title); ?> </li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                <?php if(session()->has('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php elseif(session()->has('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-octagon me-1"></i>
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <form action="<?php echo e(route('inventory.index')); ?>" method="GET" id="filterForm">
                            <div class="row text-center mb-3">
                                <div class="col-md-1 my-1">
                                    <a href="<?php echo e(route('inventory.create')); ?>" class="btn btn-primary"><i
                                            class="bi bi-plus"></i> </a>
                                </div>
                                <div class="col-md-5 my-1">
                                    <input type="date" name="tanggal" id="tanggal" class="form-control"
                                        onchange="document.getElementById('filterForm').submit();"
                                        value="<?php echo e(request('tanggal')); ?>">
                                </div>
                                <div class="col-md-5 my-1">
                                    <select onchange="document.getElementById('filterForm').submit();" name="jenis"
                                        id="jenis" class="form-control">
                                        <option value="" selected disabled>Filter Jenis Informasi</option>
                                        <option value="barang masuk">Barang Masuk</option>
                                        <option value="barang keluar">Barang Keluar</option>
                                    </select>
                                </div>

                                <?php if(auth()->user()->role == 'Owner'): ?>
                                    <div class="col-md-1 my-1">
                                        <a href="<?php echo e(route('inventory.laporan')); ?>" class="btn btn-warning"><i
                                                class="bi bi-download"></i> </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </form>

                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th> No </th>
                                        <th> Tanggal </th>
                                        <th> Jenis </th>
                                        <th> Produk </th>
                                        <th> Jumlah </th>
                                        <th> Pembayaran </th>
                                        <th> Penanggung Jawab </th>
                                        <th class="w-25"> Pesan </th>
                                        <th> Penjualan </th>
                                        <th> Pembelian </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1; ?>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($no++); ?></td>
                                            <td><?php echo e($item->created_at); ?></td>
                                            <td>
                                                <?php if($item->jenis == 'barang masuk'): ?>
                                                    <span class="badge rounded-pill bg-success"><?php echo e($item->jenis); ?></span>
                                                <?php elseif($item->jenis == 'barang keluar'): ?>
                                                    <span class="badge rounded-pill bg-danger"><?php echo e($item->jenis); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($item->produk->nama_produk); ?> </td>
                                            <td><?php echo e($item->jumlah_barang); ?></td>
                                            <td>
                                                <?php if($item->jenis == 'barang masuk'): ?>
                                                    <span class="badge rounded-pill bg-danger"><i
                                                            class="bi bi-dash-circle"></i></span>
                                                    <?php echo e(number_format($item->pembayaran, 0, ',', '.')); ?>

                                                <?php elseif($item->jenis == 'barang keluar'): ?>
                                                    <span class="badge rounded-pill bg-success"><i
                                                            class="bi bi-plus-circle"></i></span>
                                                    <?php echo e(number_format($item->pembayaran, 0, ',', '.')); ?> <br>
                                                    <?php if($item->pelacakan): ?>
                                                        <?php if($item->pelacakan->status == 'dikemas' || $item->pelacakan->status == 'dikirim'): ?>
                                                            sedang <?php echo e($item->pelacakan->status); ?>

                                                        <?php elseif($item->pelacakan->status == 'dibatalkan'): ?>
                                                            <?php echo e($item->pelacakan->status); ?>

                                                        <?php else: ?>
                                                            <?php if($item->pelacakan->jumlah_pelunasan == null): ?>
                                                                belum dibayar
                                                            <?php else: ?>
                                                                Dibayar :
                                                                <?php echo e(number_format($item->pelacakan->jumlah_pelunasan, 0, ',', '.')); ?>

                                                                <br>
                                                                <?php if($item->pelacakan->sisa_pelunasan != 0): ?>
                                                                    <span class="badge rounded-pill bg-warning"><i
                                                                            class="bi bi-exclamation-circle"></i></span><?php echo e(number_format($item->pelacakan->sisa_pelunasan, 0, ',', '.')); ?>

                                                                <?php else: ?>
                                                                    Status : Lunas
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <?php if(isset($item->staff->name)): ?>
                                                <td><?php echo e($item->staff->name); ?> ( <?php echo e($item->staff->email); ?> ) </td>
                                            <?php else: ?>
                                                <td> - </td>
                                            <?php endif; ?>

                                            <td class="w-25">
                                                <?php if($item->pesan == null): ?>
                                                    -
                                                <?php else: ?>
                                                    <?php echo e($item->pesan); ?>

                                                <?php endif; ?>
                                            </td>

                                            <td><?php echo e($item->nama_pelanggan); ?></td>
                                            <td><?php echo e($item->nama_sales); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/kopicoder/resources/views/pages/penjualan/index.blade.php ENDPATH**/ ?>