<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Tambah Data Klasifikasi</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('klasifikasi.index')); ?>">Data Klasifikasi</a></li>
                <li class="breadcrumb-item active">Tambah Data</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Tambah Data Klasifikasi</h5>
                    <form action="<?php echo e(route('klasifikasi.store')); ?>" method="POST" id="klasifikasiForm">
                        <?php echo csrf_field(); ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="gatra">Gatra <span class="text-danger">*</span></label>
                                    <select class="form-control <?php $__errorArgs = ['gatra'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="gatra" name="gatra" required>
                                        <option value="">Pilih Gatra</option>
                                        <option value="1" <?php echo e(old('gatra') == '1' ? 'selected' : ''); ?>>1 - Geografi</option>
                                        <option value="2" <?php echo e(old('gatra') == '2' ? 'selected' : ''); ?>>2 - Demografi</option>
                                        <option value="3" <?php echo e(old('gatra') == '3' ? 'selected' : ''); ?>>3 - Sumber Kekayaan Alam</option>
                                        <option value="4" <?php echo e(old('gatra') == '4' ? 'selected' : ''); ?>>4 - Ideologi</option>
                                        <option value="5" <?php echo e(old('gatra') == '5' ? 'selected' : ''); ?>>5 - Politik</option>
                                        <option value="6" <?php echo e(old('gatra') == '6' ? 'selected' : ''); ?>>6 - Ekonomi</option>
                                        <option value="7" <?php echo e(old('gatra') == '7' ? 'selected' : ''); ?>>7 - Sosial Budaya</option>
                                        <option value="8" <?php echo e(old('gatra') == '8' ? 'selected' : ''); ?>>8 - Pertahanan & Keamanan</option>
                                    </select>
                                    <?php $__errorArgs = ['gatra'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">Type <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="type" name="type" value="<?php echo e(old('type')); ?>" required>
                                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="turvar_id">Turvar ID</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['turvar_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="turvar_id" name="turvar_id" value="<?php echo e(old('turvar_id')); ?>">
                                    <?php $__errorArgs = ['turvar_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">Masukkan ID turvar dari JSON (opsional)</small>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tahun_id">Tahun ID</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['tahun_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="tahun_id" name="tahun_id" value="<?php echo e(old('tahun_id')); ?>">
                                    <?php $__errorArgs = ['tahun_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">Masukkan ID tahun dari JSON (opsional)</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="turtahun_id">Turtahun ID</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['turtahun_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="turtahun_id" name="turtahun_id" value="<?php echo e(old('turtahun_id')); ?>">
                                    <?php $__errorArgs = ['turtahun_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">Masukkan ID turtahun dari JSON (opsional)</small>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jenis_tangguh">Jenis Tangguh <span class="text-danger">*</span></label>
                                    <select class="form-control <?php $__errorArgs = ['jenis_tangguh'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="jenis_tangguh" name="jenis_tangguh" required>
                                        <option value="">Pilih Jenis Tangguh</option>
                                        <option value="keatas" <?php echo e(old('jenis_tangguh') == 'keatas' ? 'selected' : ''); ?>>Keatas</option>
                                        <option value="kebawah" <?php echo e(old('jenis_tangguh') == 'kebawah' ? 'selected' : ''); ?>>Kebawah</option>
                                    </select>
                                    <?php $__errorArgs = ['jenis_tangguh'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="batas_bawah">Batas Bawah <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" class="form-control <?php $__errorArgs = ['batas_bawah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="batas_bawah" name="batas_bawah" value="<?php echo e(old('batas_bawah')); ?>" required>
                                    <?php $__errorArgs = ['batas_bawah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="batas_atas">Batas Atas <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" class="form-control <?php $__errorArgs = ['batas_atas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="batas_atas" name="batas_atas" value="<?php echo e(old('batas_atas')); ?>" required>
                                    <?php $__errorArgs = ['batas_atas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="api">API <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['api'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="api" name="api" value="<?php echo e(old('api')); ?>" required>
                            <?php $__errorArgs = ['api'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label for="json_data">JSON Data <span class="text-danger">*</span></label>
                            <textarea class="form-control <?php $__errorArgs = ['json_data'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="json_data" name="json_data" rows="10" required 
                                      placeholder="Paste JSON data di sini..."><?php echo e(old('json_data')); ?></textarea>
                            <?php $__errorArgs = ['json_data'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="row" id="preview-section" style="display: none;">
                            <div class="col-12">
                                <h5>Preview Data dari JSON:</h5>
                                <div class="row">
                                    <div class="col-md-3">
                                        <p><strong>Subject ID:</strong> <span id="preview-subject-id"></span></p>
                                        <p><strong>Subject:</strong> <span id="preview-subject"></span></p>
                                        <p><strong>Var ID:</strong> <span id="preview-var-id"></span></p>
                                        <p><strong>Var Label:</strong> <span id="preview-var-label"></span></p>
                                    </div>
                                    <div class="col-md-3">
                                        <p><strong>Title:</strong> <span id="preview-title"></span></p>
                                        <p><strong>Turvar yang dipilih:</strong> <span id="preview-turvar"></span></p>
                                        <p><strong>Tahun yang dipilih:</strong> <span id="preview-tahun"></span></p>
                                        <p><strong>Turtahun yang dipilih:</strong> <span id="preview-turtahun"></span></p>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="turvar-select"><strong>Pilih Turvar:</strong></label>
                                            <select class="form-control" id="turvar-select">
                                                <option value="">-- Pilih Turvar --</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="tahun-select"><strong>Pilih Tahun:</strong></label>
                                            <select class="form-control" id="tahun-select">
                                                <option value="">-- Pilih Tahun --</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="turtahun-select"><strong>Pilih Turtahun:</strong></label>
                                            <select class="form-control" id="turtahun-select">
                                                <option value="">-- Pilih Turtahun --</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row" id="step-preview" style="display: none;">
                            <div class="col-12">
                                <h5>Preview Batas Atas (Steps):</h5>
                                <div class="row">
                                    <div class="col-md-2"><p><strong>Batas Atas 1:</strong> <span id="preview-step1"></span></p></div>
                                    <div class="col-md-2"><p><strong>Batas Atas 2:</strong> <span id="preview-step2"></span></p></div>
                                    <div class="col-md-2"><p><strong>Batas Atas 3:</strong> <span id="preview-step3"></span></p></div>
                                    <div class="col-md-2"><p><strong>Batas Atas 4:</strong> <span id="preview-step4"></span></p></div>
                                    <div class="col-md-2"><p><strong>Batas Atas 5:</strong> <span id="preview-step5"></span></p></div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-3">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                            <a href="<?php echo e(route('klasifikasi.index')); ?>" class="btn btn-secondary">Kembali</a>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const jsonTextarea = document.getElementById('json_data');
    const batasBawahInput = document.getElementById('batas_bawah');
    const batasAtasInput = document.getElementById('batas_atas');
    const turvarIdInput = document.getElementById('turvar_id');
    const tahunIdInput = document.getElementById('tahun_id');
    const turtahunIdInput = document.getElementById('turtahun_id');
    const turvarSelect = document.getElementById('turvar-select');
    const tahunSelect = document.getElementById('tahun-select');
    const turtahunSelect = document.getElementById('turtahun-select');
    
    let currentJsonData = null;
    
    function parseJsonData() {
        try {
            currentJsonData = JSON.parse(jsonTextarea.value);
            
            if (currentJsonData.subject && currentJsonData.subject[0] && currentJsonData.var && currentJsonData.var[0]) {
                document.getElementById('preview-subject-id').textContent = currentJsonData.subject[0].val;
                document.getElementById('preview-subject').textContent = currentJsonData.subject[0].label;
                document.getElementById('preview-var-id').textContent = currentJsonData.var[0].val;
                document.getElementById('preview-var-label').textContent = currentJsonData.var[0].label;
                document.getElementById('preview-title').textContent = currentJsonData.var[0].label;
                
                // Populate dropdowns
                populateTurvarSelect();
                populateTahunSelect();
                populateTurtahunSelect();
                
                document.getElementById('preview-section').style.display = 'block';
            }
        } catch (e) {
            document.getElementById('preview-section').style.display = 'none';
            currentJsonData = null;
        }
    }
    
    function populateTurvarSelect() {
        turvarSelect.innerHTML = '<option value="">-- Pilih Turvar --</option>';
        
        if (currentJsonData && currentJsonData.turvar) {
            currentJsonData.turvar.forEach(function(turvar) {
                const option = document.createElement('option');
                option.value = turvar.val;
                option.textContent = turvar.val + ' - ' + turvar.label;
                turvarSelect.appendChild(option);
            });
        }
    }
    
    function populateTahunSelect() {
        tahunSelect.innerHTML = '<option value="">-- Pilih Tahun --</option>';
        
        if (currentJsonData && currentJsonData.tahun) {
            currentJsonData.tahun.forEach(function(tahun) {
                const option = document.createElement('option');
                option.value = tahun.val;
                option.textContent = tahun.val + ' - ' + tahun.label;
                tahunSelect.appendChild(option);
            });
        }
    }
    
    function populateTurtahunSelect() {
        turtahunSelect.innerHTML = '<option value="">-- Pilih Turtahun --</option>';
        
        if (currentJsonData && currentJsonData.turtahun) {
            currentJsonData.turtahun.forEach(function(turtahun) {
                const option = document.createElement('option');
                option.value = turtahun.val;
                option.textContent = turtahun.val + ' - ' + turtahun.label;
                turtahunSelect.appendChild(option);
            });
        }
    }
    
    function updateTurvarId() {
        const selectedValue = turvarSelect.value;
        turvarIdInput.value = selectedValue;
        
        // Update preview turvar
        if (selectedValue && currentJsonData && currentJsonData.turvar) {
            const selectedTurvar = currentJsonData.turvar.find(t => t.val == selectedValue);
            if (selectedTurvar) {
                document.getElementById('preview-turvar').textContent = selectedTurvar.label;
            }
        } else {
            document.getElementById('preview-turvar').textContent = '';
        }
    }
    
    function updateTahunId() {
        const selectedValue = tahunSelect.value;
        tahunIdInput.value = selectedValue;
        
        // Update preview tahun
        if (selectedValue && currentJsonData && currentJsonData.tahun) {
            const selectedTahun = currentJsonData.tahun.find(t => t.val == selectedValue);
            if (selectedTahun) {
                document.getElementById('preview-tahun').textContent = selectedTahun.label;
            }
        } else {
            document.getElementById('preview-tahun').textContent = '';
        }
    }
    
    function updateTurtahunId() {
        const selectedValue = turtahunSelect.value;
        turtahunIdInput.value = selectedValue;
        
        // Update preview turtahun
        if (selectedValue && currentJsonData && currentJsonData.turtahun) {
            const selectedTurtahun = currentJsonData.turtahun.find(t => t.val == selectedValue);
            if (selectedTurtahun) {
                document.getElementById('preview-turtahun').textContent = selectedTurtahun.label;
            }
        } else {
            document.getElementById('preview-turtahun').textContent = '';
        }
    }
    
    function calculateSteps() {
        const batasBawah = parseFloat(batasBawahInput.value) || 0;
        const batasAtas = parseFloat(batasAtasInput.value) || 0;
        
        if (batasBawah && batasAtas && batasAtas > batasBawah) {
            const step = (batasAtas - batasBawah) / 5;
            
            document.getElementById('preview-step1').textContent = (batasBawah + step * 1).toFixed(2);
            document.getElementById('preview-step2').textContent = (batasBawah + step * 2).toFixed(2);
            document.getElementById('preview-step3').textContent = (batasBawah + step * 3).toFixed(2);
            document.getElementById('preview-step4').textContent = (batasBawah + step * 4).toFixed(2);
            document.getElementById('preview-step5').textContent = (batasBawah + step * 5).toFixed(2);
            
            document.getElementById('step-preview').style.display = 'block';
        } else {
            document.getElementById('step-preview').style.display = 'none';
        }
    }
    
    // Event listeners
    jsonTextarea.addEventListener('input', parseJsonData);
    batasBawahInput.addEventListener('input', calculateSteps);
    batasAtasInput.addEventListener('input', calculateSteps);
    turvarSelect.addEventListener('change', updateTurvarId);
    tahunSelect.addEventListener('change', updateTahunId);
    turtahunSelect.addEventListener('change', updateTurtahunId);
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/kopicoder/resources/views/pages/klasifikasi/create.blade.php ENDPATH**/ ?>