<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1><?php echo e($title); ?></h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active"> <?php echo e($title); ?> </li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                <?php if(session()->has('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php elseif(session()->has('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-octagon me-1"></i>
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <form action="<?php echo e(route('pelacakan.index')); ?>" method="GET" id="filterForm">
                            <div class="row text-center mb-3 align-items-center">
                                <?php if(auth()->user()->role != 'Kurir'): ?>
                                    <div class="col-md-2 my-1">
                                        <a href="<?php echo e(route('pelacakan.create')); ?>" class="btn btn-primary btn-md">
                                            <i class="bi bi-plus"></i> Data Baru
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="col-md-4 my-1">
                                    <input type="date" name="tanggal" id="tanggal" class="form-control form-control-md"
                                        onchange="document.getElementById('filterForm').submit();"
                                        value="<?php echo e(request('tanggal')); ?>">
                                </div>
                                <div class="col-md-6 my-1 d-flex justify-content-end align-items-center">
                                    <select onchange="document.getElementById('filterForm').submit();" name="jenis"
                                        id="jenis" class="form-select form-select-md me-5">
                                        <option value="" selected disabled>Filter Status</option>
                                        <option value="dikemas">Dikemas</option>
                                        <option value="dikirim">Dikirim</option>
                                        
                                        <option value="dibatalkan">Dibatalkan</option>
                                        <option value="">-- Bersihkan Filter --</option>
                                    </select>

                                    <?php if(auth()->user()->role == 'Owner'): ?>
                                        <button type="button" data-bs-toggle="modal"
                                            data-bs-target="#print-laporan-pesanan" class="btn btn-info btn-md me-4">
                                            <i class="bi bi-printer"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </form>
                        <div class="modal fade" id="print-laporan-pesanan" tabindex="-1"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form id="printLaporanPesanan" action="<?php echo e(route('pelacakan.print')); ?>" method="GET"
                                        target="_blank">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Print Laporan Transaksi</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="col-md-12 mb-3">
                                                <label for="from" class="form-label">Dari Tanggal :</label>
                                                <input type="date" name="from"
                                                    class="form-control <?php $__errorArgs = ['from'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> shadow-none"
                                                    id="from" required>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="to" class="form-label">Sampai Tanggal :</label>
                                                <input type="date" name="to"
                                                    class="form-control <?php $__errorArgs = ['to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> shadow-none"
                                                    id="to" required>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">Kembali</button>
                                            <button onclick="document.getElementById('printLaporanPesanan').submit()"
                                                class="btn btn-primary text-white shadow-none">Print</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th> No </th>
                                        <th>Order Date</th>
                                        <th>Product</th>
                                        <?php if(auth()->user()->role != 'Kurir'): ?>
                                            <th>Price</th>
                                        <?php endif; ?>
                                        <th>Quantity</th>
                                        <?php if(auth()->user()->role != 'Kurir'): ?>
                                            <th>Subtotal</th>
                                        <?php endif; ?>
                                        <th>Order Total</th>
                                        <?php if(auth()->user()->role != 'Kurir'): ?>
                                            <th>Bukti Pembayaran</th>
                                            <th>Status Pembayaran</th>
                                            <th>Detail Pembayaran</th>
                                        <?php endif; ?>
                                        <th>Status</th>
                                        <th>Detail Cust</th>
                                        <?php if(auth()->user()->role != 'Kurir'): ?>
                                            
                                            <th>Bukti Pengiriman</th>
                                            <th>Penanggung Jawab</th>
                                        <?php endif; ?>
                                        <?php if(auth()->user()->role != 'Kurir'): ?>
                                            <th>Progres</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1; ?>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = $o->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $isFirst = $index === 0;
                                                $isLast = $index === $o->products->count() - 1;
                                                $borderStyle = '';
                                                if ($isFirst) {
                                                    $borderStyle .= 'border-top: 3px solid #000;';
                                                }
                                                if ($isLast) {
                                                    $borderStyle .= 'border-bottom: 3px solid #000;';
                                                }
                                            ?>


                                            <tr style="<?php echo e($borderStyle); ?>">
                                                <?php if($isFirst): ?>
                                                    <td rowspan="<?php echo e($o->products->count()); ?>"><?php echo e($no++); ?></td>
                                                    <td rowspan="<?php echo e($o->products->count()); ?>">
                                                        <?php echo e($o->created_at->format('d M Y H:i')); ?></td>
                                                <?php endif; ?>
                                                <td><?php echo e($product->nama_produk); ?></td>
                                                <?php if(auth()->user()->role != 'Kurir'): ?>
                                                    <td>Rp <?php echo e(number_format($product->pivot->harga_produk, 0, ',', '.')); ?>

                                                    </td>
                                                <?php endif; ?>
                                                <td><?php echo e($product->pivot->quantity); ?></td>
                                                <?php if(auth()->user()->role != 'Kurir'): ?>
                                                    <td>Rp
                                                        <?php echo e(number_format($product->pivot->harga_produk * $product->pivot->quantity, 0, ',', '.')); ?>

                                                    </td>
                                                <?php endif; ?>
                                                <?php if($isFirst): ?>
                                                    <td rowspan="<?php echo e($o->products->count()); ?>">
                                                        Rp
                                                        <?php echo e(number_format($o->products->sum(fn($p) => $p->pivot->harga_produk * $p->pivot->quantity), 0, ',', '.')); ?>

                                                    </td>
                                                <?php endif; ?>
                                                <?php if(auth()->user()->role != 'Kurir'): ?>
                                                    <?php if($isFirst): ?>
                                                        <td rowspan="<?php echo e($o->products->count()); ?>">
                                                            <?php if($o->bukti && file_exists(storage_path('app/public/bukti_pembayaran/' . $o->bukti))): ?>
                                                                
                                                                <img src="<?php echo e(asset('storage/bukti_pembayaran/' . $o->bukti)); ?>"
                                                                    width="50" alt="<?php echo e($o->bukti); ?>"
                                                                    class="img-thumbnail" style="cursor: pointer;"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#imgModal<?php echo e($o->id); ?>">
                                                                
                                                                <div class="modal fade" id="imgModal<?php echo e($o->id); ?>"
                                                                    tabindex="-1"
                                                                    aria-labelledby="imageModalLabel<?php echo e($o->id); ?>"
                                                                    aria-hidden="true">
                                                                    <div
                                                                        class="modal-dialog modal-dialog-centered modal-md">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title"
                                                                                    id="imageModalLabel<?php echo e($o->id); ?>">
                                                                                    Bukti Pembayaran</h5>
                                                                                <button type="button" class="btn-close"
                                                                                    style="transform: scale(1.5);"
                                                                                    data-bs-dismiss="modal"
                                                                                    aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body text-center">
                                                                                <img src="<?php echo e(asset('storage/bukti_pembayaran/' . $o->bukti)); ?>"
                                                                                    class="img-fluid"
                                                                                    alt="Bukti Pembayaran">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php else: ?>
                                                                <span class="text-muted fw-bold">Cash</span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td rowspan="<?php echo e($o->products->count()); ?>">
                                                            <?php if($o->total == $o->jumlah_pelunasan): ?>
                                                                <span class="badge rounded-pill bg-success"> LUNAS </span>
                                                            <?php else: ?>
                                                                <span class="badge rounded-pill bg-secondary"> -
                                                                    <?php echo e(number_format($o->sisa_pelunasan, 0, ',', '.')); ?>

                                                                </span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td rowspan="<?php echo e($o->products->count()); ?>">
                                                            <button type="button" class="btn btn-primary shadow-none"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#data-pembayaran<?php echo e($o->id); ?>"><i
                                                                    class="bi bi-receipt"></i></button>
                                                            <div class="modal fade"
                                                                id="data-pembayaran<?php echo e($o->id); ?>" tabindex="-1"
                                                                aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title">Informasi Pembayaran
                                                                            </h5>
                                                                            <button type="button" class="btn-close"
                                                                                data-bs-dismiss="modal"
                                                                                aria-label="Close"></button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <table class="table table-bordered">
                                                                                <tr>
                                                                                    <td class="text-start fw-bold">Total
                                                                                        Order</td>
                                                                                    <td class="text-center">
                                                                                        <?php echo e($o->total !== null ? 'Rp ' . number_format($o->total, 0, ',', '.') : '-'); ?>

                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td class="text-start fw-bold">Jumlah
                                                                                        Telah Dibayar</td>
                                                                                    <td class="text-center">
                                                                                        <?php echo e($o->jumlah_pelunasan !== null ? 'Rp ' . number_format($o->jumlah_pelunasan, 0, ',', '.') : '-'); ?>

                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td class="text-start fw-bold">Sisa
                                                                                        Cicilan</td>
                                                                                    <td class="text-center">
                                                                                        <?php echo $o->sisa_pelunasan == 0 || $o->sisa_pelunasan === null
                                                                                            ? '<span class="badge bg-success fs-6">Lunas</span>'
                                                                                            : 'Rp ' . number_format($o->sisa_pelunasan, 0, ',', '.'); ?>

                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button"
                                                                                class="btn btn-secondary"
                                                                                data-bs-dismiss="modal">Kembali</button>
                                                                            <button type="button"
                                                                                class="btn btn-primary shadow-none"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-target="#bayar<?php echo e($o->id); ?>">Ubah</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal fade" id="bayar<?php echo e($o->id); ?>"
                                                                tabindex="-1" aria-labelledby="exampleModalLabel"
                                                                aria-hidden="true">
                                                                <div class="modal-dialog">
                                                                    <form action="<?php echo e(route('pelacakan.update', $o->id)); ?>"
                                                                        method="post">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('put'); ?>
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title">Pelunasan Barang
                                                                                </h5>
                                                                                <button type="button" class="btn-close"
                                                                                    data-bs-dismiss="modal"
                                                                                    aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body row">
                                                                                <div class="col-md-12 mb-3">
                                                                                    <label for="total"
                                                                                        class="form-label">Total</label>
                                                                                    <input type="number"
                                                                                        class="form-control <?php $__errorArgs = ['total'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> shadow-none"
                                                                                        id="total"
                                                                                        value="<?php echo e($o->total); ?>"
                                                                                        readonly>
                                                                                    <?php $__errorArgs = ['total'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                        <div class="invalid-feedback">
                                                                                            <?php echo e($message); ?>

                                                                                        </div>
                                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                                </div>
                                                                                <div class="col-md-12 mb-3">
                                                                                    <label for="sudah_dibayar"
                                                                                        class="form-label">Sudah
                                                                                        Dibayar</label>
                                                                                    <input type="number"
                                                                                        class="form-control <?php $__errorArgs = ['sudah_dibayar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> shadow-none"
                                                                                        id="sudah_dibayar"
                                                                                        value="<?php echo e($o->jumlah_pelunasan); ?>"
                                                                                        readonly>
                                                                                    <?php $__errorArgs = ['sudah_dibayar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                        <div class="invalid-feedback">
                                                                                            <?php echo e($message); ?>

                                                                                        </div>
                                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                                </div>
                                                                                <div class="col-md-12">
                                                                                    <label for="sisa_cicilan"
                                                                                        class="form-label">Sisa
                                                                                        Cicilan</label>
                                                                                    <input type="number"
                                                                                        class="form-control <?php $__errorArgs = ['sisa_cicilan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> shadow-none"
                                                                                        id="sisa_cicilan"
                                                                                        value="<?php echo e($o->sisa_pelunasan); ?>"
                                                                                        readonly>
                                                                                    <?php $__errorArgs = ['sisa_cicilan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                        <div class="invalid-feedback">
                                                                                            <?php echo e($message); ?>

                                                                                        </div>
                                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                                </div>
                                                                                <div class="col-md-6 mt-3">
                                                                                    <label for="pembayaran"
                                                                                        class="form-label">Jumlah
                                                                                        Pembayaran</label>
                                                                                    <input type="number"
                                                                                        max="<?php echo e($o->total); ?>"
                                                                                        name="pembayaran"
                                                                                        class="form-control <?php $__errorArgs = ['pembayaran'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> shadow-none"
                                                                                        id="pembayaran"
                                                                                        value="<?php echo e(old('pembayaran')); ?>">
                                                                                    <?php $__errorArgs = ['pembayaran'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                        <div class="invalid-feedback">
                                                                                            <?php echo e($message); ?>

                                                                                        </div>
                                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                                </div>
                                                                                <div class="col-md-6 mt-3">
                                                                                    <label for="sisa"
                                                                                        class="form-label">Sisa
                                                                                        Pembayaran</label>
                                                                                    <input type="number" name="sisa"
                                                                                        class="form-control <?php $__errorArgs = ['sisa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> shadow-none"
                                                                                        id="sisa"
                                                                                        value="<?php echo e(old('sisa')); ?>"
                                                                                        readonly>
                                                                                    <?php $__errorArgs = ['sisa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                        <div class="invalid-feedback">
                                                                                            <?php echo e($message); ?>

                                                                                        </div>
                                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                                </div>
                                                                            </div>
                                                                            <div
                                                                                class="modal-footer d-flex justify-content-between align-items-center">
                                                                                <button type="button"
                                                                                    class="btn btn-secondary"
                                                                                    data-bs-dismiss="modal">Kembali</button>
                                                                                <button type="submit"
                                                                                    class="btn btn-primary">Kirim</button>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if($isFirst): ?>
                                                    <td rowspan="<?php echo e($o->products->count()); ?>">
                                                        <?php if($o->status == 'dikemas'): ?>
                                                            <button type="button" class="btn btn-secondary shadow-none"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#status-pesanan<?php echo e($o->id); ?>">
                                                                <i
                                                                    class="bi bi-box-seam"></i>&nbsp;<?php echo e(ucfirst($o->status)); ?></button>
                                                        <?php elseif($o->status == 'dikirim'): ?>
                                                            <button type="button" class="btn btn-primary shadow-none"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#status-pesanan<?php echo e($o->id); ?>">
                                                                <i
                                                                    class="bi bi-truck"></i>&nbsp;<?php echo e(ucfirst($o->status)); ?></button>
                                                        <?php elseif($o->status == 'selesai'): ?>
                                                            <button type="button" class="btn btn-success shadow-none"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#status-pesanan<?php echo e($o->id); ?>">
                                                                <i
                                                                    class="bi bi-check-circle-fill"></i>&nbsp;<?php echo e(ucfirst($o->status)); ?></button>
                                                        <?php elseif($o->status == 'dibatalkan'): ?>
                                                            <button type="button" class="btn btn-danger shadow-none"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#status-pesanan<?php echo e($o->id); ?>"><i
                                                                    class="bi bi-x-circle-fill"></i>&nbsp;<?php echo e(ucfirst($o->status)); ?></button>
                                                        <?php endif; ?>
                                                        <?php if(auth()->user()->role != 'Kurir'): ?>
                                                            <div class="modal fade"
                                                                id="status-pesanan<?php echo e($o->id); ?>" tabindex="-1"
                                                                aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <form
                                                                            action="<?php echo e(route('pelacakan.update.status', $o->id)); ?>"
                                                                            method="POST">
                                                                            <?php echo csrf_field(); ?>
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title">Ubah Status Pesanan
                                                                                </h5>
                                                                                <button type="button" class="btn-close"
                                                                                    data-bs-dismiss="modal"
                                                                                    aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <label for="status"
                                                                                    class="form-label">Ubah Status</label>
                                                                                <select name="status" id="status"
                                                                                    class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                                                    <option disabled selected>Pilih Status
                                                                                    </option>
                                                                                    <option value="dikemas"
                                                                                        <?php echo e($o->status == 'dikemas' ? 'selected' : ''); ?>>
                                                                                        Dikemas</option>
                                                                                    <option value="dikirim"
                                                                                        <?php echo e($o->status == 'dikirim' ? 'selected' : ''); ?>>
                                                                                        Dikirim</option>
                                                                                    
                                                                                    <option value="dibatalkan"
                                                                                        <?php echo e($o->status == 'dibatalkan' ? 'selected' : ''); ?>>
                                                                                        Dibatalkan</option>
                                                                                </select>
                                                                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                    <div class="invalid-feedback">
                                                                                        <?php echo e($message); ?>

                                                                                    </div>
                                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button"
                                                                                    class="btn btn-secondary"
                                                                                    data-bs-dismiss="modal">Kembali</button>
                                                                                <button type="submit"
                                                                                    class="btn btn-primary text-white shadow-none">Simpan</button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td rowspan="<?php echo e($o->products->count()); ?>">
                                                        <button type="button" class="btn btn-primary shadow-none"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#data-cust<?php echo e($o->customer->id); ?>"><i
                                                                class="bi bi-person-vcard"></i></button>
                                                        <div class="modal fade" id="data-cust<?php echo e($o->customer->id); ?>"
                                                            tabindex="-1" aria-labelledby="exampleModalLabel"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title">Informasi Customer</h5>
                                                                        <button type="button" class="btn-close"
                                                                            data-bs-dismiss="modal"
                                                                            aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <table>
                                                                            <tr>
                                                                                <td> Nama </td>
                                                                                <td class="w-25"> : </td>
                                                                                <td> <?php echo e($o->customer->nama_pelanggan ?? '-'); ?>

                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td> No. HP </td>
                                                                                <td class="w-25"> : </td>
                                                                                <td>
                                                                                    <?php echo e($o->customer->phone ?? '-'); ?>

                                                                                    <?php if(!empty($o->customer->phone)): ?>
                                                                                        <?php
                                                                                            $noHp = preg_replace(
                                                                                                '/[^0-9]/',
                                                                                                '',
                                                                                                $o->customer->phone,
                                                                                            ); // hapus karakter non-digit
                                                                                            if (
                                                                                                strpos($noHp, '0') === 0
                                                                                            ) {
                                                                                                $noHp =
                                                                                                    '62' .
                                                                                                    substr($noHp, 1); // ganti 0 jadi 62
                                                                                            }
                                                                                            $whatsappLink =
                                                                                                'https://wa.me/' .
                                                                                                $noHp;
                                                                                        ?>
                                                                                        <a href="<?php echo e($whatsappLink); ?>"
                                                                                            target="_blank"
                                                                                            class="btn btn-success btn-sm ms-2">
                                                                                            <i class="bi bi-whatsapp"></i>
                                                                                        </a>
                                                                                    <?php endif; ?>
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td> Alamat </td>
                                                                                <td class="w-25"> : </td>
                                                                                <td> <?php echo e($o->customer->alamat_pelanggan ?? '-'); ?>

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary"
                                                                            data-bs-dismiss="modal">Kembali</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <?php if(auth()->user()->role != 'Kurir'): ?>
                                                        <td rowspan="<?php echo e($o->products->count()); ?>">
                                                            <?php if($o->bukti_pengiriman): ?>
                                                                <button type="button"
                                                                    class="btn btn-outline-success shadow-none"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#bukti<?php echo e($o->id); ?>"><i
                                                                        class="bi bi-check-circle-fill"></i></button>
                                                                <div class="modal fade" id="bukti<?php echo e($o->id); ?>"
                                                                    tabindex="-1" aria-labelledby="exampleModalLabel"
                                                                    aria-hidden="true">
                                                                    <div class="modal-dialog">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title">Bukti Pengiriman
                                                                                </h5>
                                                                                <button type="button" class="btn-close"
                                                                                    data-bs-dismiss="modal"
                                                                                    aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <img src="<?php echo e(asset('storage/bukti_pengiriman/' . $o->bukti_pengiriman)); ?>"
                                                                                    class="img-fluid"
                                                                                    alt="Bukti Pengiriman">
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button"
                                                                                    class="btn btn-secondary"
                                                                                    data-bs-dismiss="modal">Kembali</button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php else: ?>
                                                                <p>-</p>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td rowspan="<?php echo e($o->products->count()); ?>">
                                                            <?php echo e($o->staff->name ?? '-'); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if(auth()->user()->role != 'Kurir'): ?>
                                                        <td>
                                                            <?php if($o->status == 'dikirim'): ?>
                                                                


                                                                
                                                            <?php elseif($o->status == 'selesai'): ?>
                                                                <button type="button"
                                                                    class="btn btn-outline-success shadow-none"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#bukti<?php echo e($o->id); ?>"><i
                                                                        class="bi bi-check-circle-fill"></i></button>
                                                                <div class="modal fade" id="bukti<?php echo e($o->id); ?>"
                                                                    tabindex="-1" aria-labelledby="exampleModalLabel"
                                                                    aria-hidden="true">
                                                                    <div class="modal-dialog">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title">Bukti Pengiriman
                                                                                </h5>
                                                                                <button type="button" class="btn-close"
                                                                                    data-bs-dismiss="modal"
                                                                                    aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <img src="<?php echo e(asset('storage/bukti_pengiriman/' . $o->bukti_pengiriman)); ?>"
                                                                                    class="img-fluid"
                                                                                    alt="Bukti Pengiriman">
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button"
                                                                                    class="btn btn-secondary"
                                                                                    data-bs-dismiss="modal">Kembali</button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php elseif($o->status == 'dibatalkan'): ?>
                                                                <span
                                                                    class="badge rounded-pill bg-danger"><?php echo e($o->status); ?></span>
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const pembayaranInput = document.getElementById('pembayaran');

            // Call the function when the "pembayaran" field is changed
            pembayaranInput.addEventListener('input', calculateSisa);

            function calculateSisa() {
                const total = parseFloat(document.getElementById('sisa_cicilan').value) || 0;
                const pembayaran = parseFloat(pembayaranInput.value) || 0;
                const sisa = total - pembayaran;

                document.getElementById('sisa').value = sisa >= 0 ? sisa : 0;
            }
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Select all elements with the class 'pembayaran_sisa'
            const pembayaranSisaElements = document.querySelectorAll('.pembayaran_sisa');

            pembayaranSisaElements.forEach(pembayaranSisa => {
                // Add event listener to each 'pembayaran_sisa' input
                pembayaranSisa.addEventListener('input', function() {
                    const sisaPelunasan = parseFloat(pembayaranSisa.closest('.modal-body')
                        .querySelector('.sisa_pelunasan').value) || 0;
                    const pembayaran = parseFloat(pembayaranSisa.value) || 0;
                    const sisa = sisaPelunasan - pembayaran;

                    // Update the corresponding 'sisa_pembayaran' input in the same form
                    const sisaPembayaran = pembayaranSisa.closest('.modal-body').querySelector(
                        '.sisa_pembayaran');
                    sisaPembayaran.value = sisa >= 0 ? sisa : 0;
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/kopicoder/resources/views/pages/pelacakan/index.blade.php ENDPATH**/ ?>