<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Data Klasifikasi</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active">Data Klasifikasi</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                
                <?php if(session()->has('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php elseif(session()->has('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-octagon me-1"></i>
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <div class="d-flex align-items-center justify-content-between m-3">
                            <h5 class="card-title">Total : <?php echo e($data_klasifikasi->count()); ?> Data</h5>
                            <div>
                                <form action="<?php echo e(route('klasifikasi.update.all')); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-warning me-2" onclick="return confirm('Apakah Anda yakin ingin mengupdate semua data klasifikasi?')">
                                        <i class="bi bi-arrow-clockwise"></i> Update Semua Data
                                    </button>
                                </form>
                                <a href="<?php echo e(route('klasifikasi.create')); ?>" class="btn btn-success me-2">
                                    <i class="bi bi-plus-lg"></i> Tambah Data (Form)
                                </a>
                                <!-- <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createModal">
                                    <i class="bi bi-plus"></i> Data Baru (Modal)
                                </button> -->
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table datatable" id="pegawai">
                                <thead>
                                    <tr>
                                        <th>No.</th>
                                        <th>Gatra</th>
                                        <th>Type</th>
                                        <th>Subject</th>
                                        <th>Var</th>
                                        <th>Turvar</th>
                                        <th>Tahun</th>
                                        <th>Turtahun</th>
                                        <!-- <th>API</th> -->
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    <?php $__empty_1 = true; $__currentLoopData = $data_klasifikasi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $klasifikasi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($no++); ?></td>
                                            <td><?php echo e($klasifikasi->gatra); ?></td>
                                            <td><?php echo e($klasifikasi->type); ?></td>
                                            <td><?php echo e($klasifikasi->subject); ?></td>
                                            <td><?php echo e($klasifikasi->var); ?></td>
                                            <td><?php echo e($klasifikasi->turvar ?? '-'); ?></td>
                                            <td><?php echo e($klasifikasi->tahun ?? '-'); ?></td>
                                            <td><?php echo e($klasifikasi->turtahun ?? '-'); ?></td>
                                            <!-- <td><?php echo e(Str::limit($klasifikasi->api, 50)); ?></td> -->
                                            <td>
                                                
                                                <button type="button" class="btn btn-info btn-sm shadow-none me-1" data-bs-toggle="modal" data-bs-target="#detailModal" onclick="loadDetailData(<?php echo e($klasifikasi->id); ?>)" title="Lihat Detail Klasifikasi">
                                                    <i class="bi bi-list-ul"></i> Detail
                                                </button>
                                                
                                                <!-- <button type="button" class="btn btn-primary btn-sm shadow-none me-1" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($klasifikasi->id); ?>" title="Edit">
                                                    <i class="bi bi-pencil"></i>
                                                </button> -->
                                                <button type="button" class="btn btn-danger btn-sm shadow-none" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($klasifikasi->id); ?>" title="Hapus">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </td>
                                        </tr>

                                        <!-- Modal Edit Klasifikasi -->
                                        <div class="modal fade" id="editModal<?php echo e($klasifikasi->id); ?>" tabindex="-1" aria-labelledby="editModalLabel<?php echo e($klasifikasi->id); ?>" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="editModalLabel<?php echo e($klasifikasi->id); ?>">Edit Data Klasifikasi</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        
                                                        <form action="<?php echo e(route('klasifikasi.update', $klasifikasi->id)); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="mb-3">
                                                                <label for="gatra<?php echo e($klasifikasi->id); ?>" class="form-label">Gatra</label>
                                                                <input type="text" class="form-control" id="gatra<?php echo e($klasifikasi->id); ?>" name="gatra" value="<?php echo e($klasifikasi->gatra); ?>" required>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="api<?php echo e($klasifikasi->id); ?>" class="form-label">API</label>
                                                                <input type="text" class="form-control" id="api<?php echo e($klasifikasi->id); ?>" name="api" value="<?php echo e($klasifikasi->api); ?>" required>
                                                            </div>
                                                            <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- End Modal Edit Klasifikasi -->

                                        <!-- Modal Hapus Klasifikasi -->
                                        <div class="modal fade" id="deleteModal<?php echo e($klasifikasi->id); ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?php echo e($klasifikasi->id); ?>" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel<?php echo e($klasifikasi->id); ?>">Hapus Data Klasifikasi</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Apakah Anda yakin ingin menghapus klasifikasi <strong><?php echo e($klasifikasi->gatra); ?></strong>?
                                                    </div>
                                                    <div class="modal-footer">
                                                        <form action="<?php echo e(route('klasifikasi.destroy', $klasifikasi->id)); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="btn btn-danger">Hapus</button>
                                                        </form>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- End Modal Hapus Klasifikasi -->

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="10" class="text-center">Tidak ada data klasifikasi.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal Create Klasifikasi -->
    <div class="modal fade" id="createModal" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createModalLabel">Tambah klasifikasi Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    
                    <form action="<?php echo e(route('klasifikasi.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="gatra" class="form-label">Gatra</label>
                            <input type="text" class="form-control" id="gatra" name="gatra" required>
                        </div>
                        <div class="mb-3">
                            <label for="type" class="form-label">Type</label>
                            <input type="text" class="form-control" id="type" name="type" required>
                        </div>
                        <div class="mb-3">
                            <label for="turvar_id" class="form-label">Turvar ID (Opsional)</label>
                            <input type="number" class="form-control" id="turvar_id" name="turvar_id">
                        </div>
                        <div class="mb-3">
                            <label for="tahun_id" class="form-label">Tahun ID (Opsional)</label>
                            <input type="number" class="form-control" id="tahun_id" name="tahun_id">
                        </div>
                        <div class="mb-3">
                            <label for="turtahun_id" class="form-label">Turtahun ID (Opsional)</label>
                            <input type="number" class="form-control" id="turtahun_id" name="turtahun_id">
                        </div>
                        <div class="mb-3">
                            <label for="api" class="form-label">API</label>
                            <input type="text" class="form-control" id="api" name="api" required>
                        </div>
                        <div class="mb-3">
                            <label for="batas_bawah" class="form-label">Batas Bawah</label>
                            <input type="number" step="0.01" class="form-control" id="batas_bawah" name="batas_bawah" required>
                        </div>
                        <div class="mb-3">
                            <label for="batas_atas" class="form-label">Batas Atas</label>
                            <input type="number" step="0.01" class="form-control" id="batas_atas" name="batas_atas" required>
                        </div>
                        <div class="mb-3">
                            <label for="json_data" class="form-label">JSON Data</label>
                            <textarea class="form-control" id="json_data" name="json_data" rows="5" required placeholder="Paste JSON data di sini..."></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Modal Create Klasifikasi -->

    <script>
        function toggleDetailTable(klasifikasiId) {
            const detailTable = document.getElementById('detailTable' + klasifikasiId);
            const toggleBtn = document.getElementById('toggleDetailBtn' + klasifikasiId);
            const toggleIcon = document.getElementById('toggleIcon' + klasifikasiId);
            const toggleText = document.getElementById('toggleText' + klasifikasiId);
            
            if (detailTable.style.display === 'none') {
                // Show detail table
                detailTable.style.display = 'block';
                toggleBtn.className = 'btn btn-warning';
                toggleIcon.className = 'bi bi-eye-slash';
                toggleText.textContent = 'Hide Detail';
            } else {
                // Hide detail table
                detailTable.style.display = 'none';
                toggleBtn.className = 'btn btn-success';
                toggleIcon.className = 'bi bi-eye';
                toggleText.textContent = 'Show Detail';
            }
        }
        
        // Function untuk load detail data
        function loadDetailData(id) {
            // Tampilkan modal
            const modal = new bootstrap.Modal(document.getElementById('detailModal'));
            modal.show();
            
            // Tampilkan loading spinner
            document.getElementById('detailContent').innerHTML = `
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            `;
            
            // Fetch data dari controller
            fetch(`/admin/data-klasifikasi/${id}`)
                .then(response => response.json())
                .then(data => {
                    const klasifikasi = data.klasifikasi;
                    const details = data.detailKlasifikasi;
                    
                    // Hitung distribusi nilai indeks
                    let distribution = {1: 0, 2: 0, 3: 0, 4: 0, 5: 0};
                    details.forEach(detail => {
                        distribution[detail.nilai_indeks]++;
                    });
                    
                    // Update modal title
                    document.getElementById('detailModalLabel').textContent = `Detail Data Klasifikasi: ${klasifikasi.gatra}`;
                    
                    // Build content
                    let content = `
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>Informasi Klasifikasi:</strong><br>
                                Gatra: ${klasifikasi.gatra}<br>
                                Type: ${klasifikasi.type}<br>
                                Jenis Tangguh: ${klasifikasi.jenis_tangguh}<br>
                                Batas: ${klasifikasi.batas_bawah} - ${klasifikasi.batas_atas5}
                            </div>
                            <div class="col-md-6">
                                <strong>Distribusi Nilai Indeks:</strong><br>
                                Indeks 1: <span class="badge bg-primary">${distribution[1]}</span><br>
                                Indeks 2: <span class="badge bg-primary">${distribution[2]}</span><br>
                                Indeks 3: <span class="badge bg-primary">${distribution[3]}</span><br>
                                Indeks 4: <span class="badge bg-primary">${distribution[4]}</span><br>
                                Indeks 5: <span class="badge bg-primary">${distribution[5]}</span><br>
                            </div>
                        </div>
                        
                        <!-- Tombol Show/Hide Detail -->
                        <div class="d-flex justify-content-center mb-3">
                            <button type="button" class="btn btn-success" id="toggleDetailBtn" onclick="toggleDetailTableModal()">
                                <i class="bi bi-eye" id="toggleIcon"></i> 
                                <span id="toggleText">Show Detail</span>
                            </button>
                        </div>
                        
                        <!-- Tabel Detail (Hidden by default) -->
                        <div id="detailTableModal" style="display: none;">
                            <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                                <table class="table table-sm table-striped">
                                    <thead class="table-dark sticky-top">
                                        <tr>
                                            <th>#</th>
                                            <th>Provinsi</th>
                                            <th>Vervar ID</th>
                                            <th>Datacontent ID</th>
                                            <th>Nilai</th>
                                            <th>Indeks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                    `;
                    
                    // Sort details by province
                    details.sort((a, b) => a.prov.localeCompare(b.prov));
                    
                    details.forEach((detail, index) => {
                        let badgeClass;
                        switch(detail.nilai_indeks) {
                            case 5: badgeClass = 'bg-success'; break;
                            case 4: badgeClass = 'bg-info'; break;
                            case 3: badgeClass = 'bg-warning'; break;
                            case 2: badgeClass = 'bg-secondary'; break;
                            default: badgeClass = 'bg-danger'; break;
                        }
                        
                        content += `
                            <tr>
                                <td>${index + 1}</td>
                                <td>${detail.prov}</td>
                                <td>${detail.vervar_id}</td>
                                <td>${detail.datacontent_id}</td>
                                <td>${parseFloat(detail.datacontent_val).toFixed(2)}</td>
                                <td><span class="badge ${badgeClass}">${detail.nilai_indeks}</span></td>
                            </tr>
                        `;
                    });
                    
                    content += `
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    `;
                    
                    document.getElementById('detailContent').innerHTML = content;
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('detailContent').innerHTML = `
                        <div class="alert alert-danger">
                            Terjadi kesalahan saat memuat data detail.
                        </div>
                    `;
                });
        }
        
        // Function untuk toggle detail table di dalam modal
        function toggleDetailTableModal() {
            const detailTable = document.getElementById('detailTableModal');
            const toggleBtn = document.getElementById('toggleDetailBtn');
            const toggleIcon = document.getElementById('toggleIcon');
            const toggleText = document.getElementById('toggleText');
            
            if (detailTable.style.display === 'none') {
                // Show detail table
                detailTable.style.display = 'block';
                toggleBtn.className = 'btn btn-warning';
                toggleIcon.className = 'bi bi-eye-slash';
                toggleText.textContent = 'Hide Detail';
            } else {
                // Hide detail table
                detailTable.style.display = 'none';
                toggleBtn.className = 'btn btn-success';
                toggleIcon.className = 'bi bi-eye';
                toggleText.textContent = 'Show Detail';
            }
        }
    </script>

    <!-- Modal Detail Klasifikasi Universal -->
    <div class="modal fade" id="detailModal" tabindex="-1" aria-labelledby="detailModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="detailModalLabel">Detail Data Klasifikasi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="detailContent">
                        <!-- Content akan dimuat di sini -->
                        <div class="text-center">
                            <div class="spinner-border" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/kopicoder/resources/views/pages/data-klasifikasi/index.blade.php ENDPATH**/ ?>