<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Http\Controllers\KlasifikasiController;
use App\Models\Klasifikasi;

echo "=== Test KlasifikasiController ===\n\n";

try {
    // Test 1: Check if data exists
    $klasifikasiCount = Klasifikasi::with('detailKlasifikasi')->count();
    echo "1. Total Klasifikasi: $klasifikasiCount\n";
    
    if ($klasifikasiCount > 0) {
        // Test 2: Simulate controller index method
        $controller = new KlasifikasiController();
        
        // Get data like the controller would
        $no = 1;
        $data_klasifikasi = Klasifikasi::with('detailKlasifikasi')->orderBy('gatra')->get();
        
        echo "2. Data loaded successfully with " . $data_klasifikasi->count() . " records\n";
        
        // Test 3: Check detail relationship
        foreach ($data_klasifikasi as $klasifikasi) {
            $detailCount = $klasifikasi->detailKlasifikasi->count();
            echo "3. Klasifikasi '{$klasifikasi->gatra}' has {$detailCount} detail records\n";
            
            if ($detailCount > 0) {
                // Check some details
                $firstDetail = $klasifikasi->detailKlasifikasi->first();
                echo "   - Sample detail: {$firstDetail->prov} = {$firstDetail->datacontent_val} (Indeks: {$firstDetail->nilai_indeks})\n";
                
                // Check distribution
                $distribution = [];
                for ($i = 1; $i <= 5; $i++) {
                    $distribution[$i] = $klasifikasi->detailKlasifikasi->where('nilai_indeks', $i)->count();
                }
                echo "   - Distribution: " . implode(', ', array_map(function($k, $v) { return "Indeks $k: $v"; }, array_keys($distribution), $distribution)) . "\n";
            }
        }
        
        echo "\n4. Testing 'Update All' functionality:\n";
        
        // Test update all functionality
        foreach ($data_klasifikasi as $klasifikasi) {
            if ($klasifikasi->detailKlasifikasi->count() > 0) {
                $beforeUpdate = $klasifikasi->detailKlasifikasi->pluck('nilai_indeks')->toArray();
                echo "   - Before update sample (first 5): " . implode(', ', array_slice($beforeUpdate, 0, 5)) . "\n";
                
                // Simulate recalculation for one record
                $detail = $klasifikasi->detailKlasifikasi->first();
                $parentData = [
                    'jenis_tangguh' => $klasifikasi->jenis_tangguh,
                    'batas_bawah' => $klasifikasi->batas_bawah,
                    'batas_atas1' => $klasifikasi->batas_atas1,
                    'batas_atas2' => $klasifikasi->batas_atas2,
                    'batas_atas3' => $klasifikasi->batas_atas3,
                    'batas_atas4' => $klasifikasi->batas_atas4,
                    'batas_atas5' => $klasifikasi->batas_atas5,
                ];
                
                // Calculate nilai_indeks
                $datacontentVal = (float)$detail->datacontent_val;
                $jenisTangguh = $parentData['jenis_tangguh'];
                
                $boundaries = [
                    ['min' => $parentData['batas_bawah'], 'max' => $parentData['batas_atas1']],
                    ['min' => $parentData['batas_atas1'], 'max' => $parentData['batas_atas2']],
                    ['min' => $parentData['batas_atas2'], 'max' => $parentData['batas_atas3']],
                    ['min' => $parentData['batas_atas3'], 'max' => $parentData['batas_atas4']],
                    ['min' => $parentData['batas_atas4'], 'max' => $parentData['batas_atas5']],
                ];

                $indeks = 5;
                for ($i = 0; $i < count($boundaries); $i++) {
                    if ($datacontentVal >= $boundaries[$i]['min'] && $datacontentVal < $boundaries[$i]['max']) {
                        $indeks = $i + 1;
                        break;
                    }
                    if ($i == count($boundaries) - 1 && $datacontentVal <= $boundaries[$i]['max']) {
                        $indeks = $i + 1;
                        break;
                    }
                }

                if ($jenisTangguh === 'kebawah') {
                    $indeks = 6 - $indeks;
                }
                
                echo "   - Sample recalculation: Value {$datacontentVal} -> Indeks {$indeks} (was {$detail->nilai_indeks})\n";
                break;
            }
        }
    }
    
    echo "\n=== Test Completed Successfully ===\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
