<?php
require 'vendor/autoload.php';
$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== TESTING PRODUCT CREATION ===\n";

try {
    $product = App\Models\Product::create([
        'nama_produk' => 'Test Product Manual',
        'foto_produk' => 'default-product.svg',
        'harga_produk' => 50000,
        'stok_produk' => 10,
        'best_seller' => 0,
        'id_sales' => 1, // ID sales yang ada
    ]);
    
    echo "SUCCESS: Product created with ID: " . $product->id . "\n";
    echo "Product data:\n";
    echo "  Nama: " . $product->nama_produk . "\n";
    echo "  Harga: " . $product->harga_produk . "\n";
    echo "  Stok: " . $product->stok_produk . "\n";
    echo "  Sales ID: " . $product->id_sales . "\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n=== END TEST ===\n";
