<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Models\Klasifikasi;
use App\Models\DetailKlasifikasi;

echo "=== Test Detail Klasifikasi ===\n\n";

try {
    // Test 1: Check if any klasifikasi exists
    $klasifikasiCount = Klasifikasi::count();
    echo "1. Total Klasifikasi: $klasifikasiCount\n";
    
    if ($klasifikasiCount > 0) {
        // Test 2: Get the latest klasifikasi with its details
        $latestKlasifikasi = Klasifikasi::with('detailKlasifikasi')->latest()->first();
        echo "2. Latest Klasifikasi: {$latestKlasifikasi->gatra} (ID: {$latestKlasifikasi->id})\n";
        echo "   - Type: {$latestKlasifikasi->type}\n";
        echo "   - Jenis Tangguh: {$latestKlasifikasi->jenis_tangguh}\n";
        echo "   - Batas Bawah: {$latestKlasifikasi->batas_bawah}\n";
        echo "   - Batas Atas1: {$latestKlasifikasi->batas_atas1}\n";
        echo "   - Batas Atas2: {$latestKlasifikasi->batas_atas2}\n";
        echo "   - Batas Atas3: {$latestKlasifikasi->batas_atas3}\n";
        echo "   - Batas Atas4: {$latestKlasifikasi->batas_atas4}\n";
        echo "   - Batas Atas5: {$latestKlasifikasi->batas_atas5}\n\n";
        
        // Test 3: Check detail klasifikasi count
        $detailCount = $latestKlasifikasi->detailKlasifikasi->count();
        echo "3. Detail Klasifikasi Count: $detailCount\n\n";
        
        if ($detailCount > 0) {
            echo "4. Sample Detail Klasifikasi Records:\n";
            foreach ($latestKlasifikasi->detailKlasifikasi->take(5) as $index => $detail) {
                echo "   " . ($index + 1) . ". Vervar: {$detail->vervar} (ID: {$detail->vervar_id})\n";
                echo "      - Datacontent ID: {$detail->datacontent_id}\n";
                echo "      - Datacontent Val: {$detail->datacontent_val}\n";
                echo "      - Nilai Indeks: {$detail->nilai_indeks}\n";
                echo "      - Prov: {$detail->prov}\n\n";
            }
        } else {
            echo "4. No detail klasifikasi records found.\n";
        }
        
        // Test 4: Check data distribution by nilai_indeks
        echo "5. Distribusi Nilai Indeks:\n";
        for ($i = 1; $i <= 5; $i++) {
            $count = DetailKlasifikasi::where('klasifikasi_id', $latestKlasifikasi->id)
                                   ->where('nilai_indeks', $i)
                                   ->count();
            echo "   - Indeks $i: $count records\n";
        }
        
    } else {
        echo "2. No klasifikasi data found. Please create some data first.\n";
    }
    
    echo "\n=== Test Completed Successfully ===\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
