<?php
require 'vendor/autoload.php';
$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== TESTING FIXED CONTROLLER ===\n";

// Create a mock request to test the fixed logging
$requestData = [
    'nama_produk' => 'Test Fixed Controller',
    'nama_sales' => '1',
    'harga_produk' => '50000',
    'stok_produk' => '15',
    'best_seller' => '1'
];

echo "Creating test product with data:\n";
foreach ($requestData as $key => $value) {
    echo "  {$key}: {$value}\n";
}

try {
    // Test manual creation first
    $product = App\Models\Product::create([
        'nama_produk' => $requestData['nama_produk'],
        'foto_produk' => 'default-product.svg',
        'harga_produk' => $requestData['harga_produk'],
        'stok_produk' => $requestData['stok_produk'],
        'best_seller' => $requestData['best_seller'],
        'id_sales' => $requestData['nama_sales'],
    ]);
    
    echo "\n✅ SUCCESS: Product created with ID: " . $product->id . "\n";
    echo "Now you can try the web form - the logging error is fixed!\n";
    
} catch (Exception $e) {
    echo "\n❌ ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== INSTRUCTIONS FOR WEB TESTING ===\n";
echo "1. Open your browser and go to the admin data-product page\n";
echo "2. Click 'Tambah' button to open the form\n";
echo "3. Fill all required fields:\n";
echo "   - Nama Product: [any product name]\n";
echo "   - Sales: [select one from dropdown]\n";
echo "   - Harga Product: [any number]\n";
echo "   - Stok Product: [any number]\n";
echo "   - Best Seller: [choose Ya or Tidak]\n";
echo "4. Submit the form\n";
echo "5. Check the Laravel log file for debug info: storage/logs/laravel.log\n";
echo "\nThe TypeError has been fixed!\n";
echo "\n=== END TEST ===\n";
