<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Models\Klasifikasi;

echo "=== Test Fixed View Layout ===\n\n";

try {
    // Test 1: Check klasifikasi data
    $klasifikasiData = Klasifikasi::with('detailKlasifikasi')->get();
    echo "1. Total Klasifikasi: " . $klasifikasiData->count() . "\n";
    
    foreach ($klasifikasiData as $klasifikasi) {
        $detailCount = $klasifikasi->detailKlasifikasi->count();
        echo "   - Klasifikasi '{$klasifikasi->gatra}': {$detailCount} detail records\n";
    }
    
    // Test 2: Check view structure
    $viewPath = 'resources/views/pages/data-klasifikasi/index.blade.php';
    $viewContent = file_get_contents($viewPath);
    
    echo "\n2. Checking updated view structure:\n";
    
    $checks = [
        'No Detail Count column' => strpos($viewContent, '<th>Detail Count</th>') === false,
        'Detail button with text' => strpos($viewContent, '</i> Detail') !== false,
        'List icon' => strpos($viewContent, 'bi-list-ul') !== false,
        'No Detail badge' => strpos($viewContent, 'No Detail') !== false,
        'Tooltip with count' => strpos($viewContent, 'title="Lihat Detail') !== false,
        'Modal still exists' => strpos($viewContent, 'detailModal') !== false,
        'Toggle functionality' => strpos($viewContent, 'toggleDetailTable') !== false,
        'Correct colspan' => strpos($viewContent, 'colspan="10"') !== false,
    ];
    
    foreach ($checks as $check => $result) {
        echo "   - $check: " . ($result ? '✓ CORRECT' : '✗ ISSUE') . "\n";
    }
    
    echo "\n3. Expected behavior:\n";
    echo "   - Main table shows basic klasifikasi info without detail count column\n";
    echo "   - 'Detail' button in action column (only if has detail data)\n";
    echo "   - Button shows count in tooltip\n";
    echo "   - Clicking 'Detail' button opens modal with hidden table initially\n";
    echo "   - Modal has 'Show Detail' button to reveal the detail table\n";
    echo "   - Clean layout focused on main klasifikasi data\n";
    
    echo "\n=== Test Completed Successfully ===\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
