<?php
require 'vendor/autoload.php';
$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== FORM SIMULATION TEST ===\n";

// Simulate form data
$formData = [
    'nama_produk' => 'Test Product Form Simulation',
    'nama_sales' => '1', // ID sales yang valid
    'harga_produk' => '75000',
    'stok_produk' => '20',
    'best_seller' => '0'
];

echo "Form data to simulate:\n";
foreach ($formData as $key => $value) {
    echo "  {$key}: {$value}\n";
}

// Simulate validation
try {
    $validator = Validator::make($formData, [
        'nama_produk' => 'required|string|max:255',
        'foto_produk' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        'nama_sales' => 'required|exists:sales,id',
        'harga_produk' => 'required|numeric|min:0',
        'stok_produk' => 'required|integer|min:0',
        'best_seller' => 'required|integer|min:0|max:1',
    ]);
    
    if ($validator->fails()) {
        echo "\nValidation FAILED:\n";
        foreach ($validator->errors()->all() as $error) {
            echo "  - {$error}\n";
        }
    } else {
        echo "\nValidation PASSED! Creating product...\n";
        
        // Create product
        $product = App\Models\Product::create([
            'nama_produk' => $formData['nama_produk'],
            'foto_produk' => 'default-product.svg',
            'harga_produk' => $formData['harga_produk'],
            'stok_produk' => $formData['stok_produk'],
            'best_seller' => $formData['best_seller'],
            'id_sales' => $formData['nama_sales'],
        ]);
        
        echo "SUCCESS: Product created with ID: " . $product->id . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== END TEST ===\n";
