<?php
require 'vendor/autoload.php';
$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== TESTING GATRA API PREPARATION ===\n";

try {
    // Cek data Gatra yang ada
    $gatraCount = App\Models\Gatra::count();
    echo "Current Gatra records: " . $gatraCount . "\n";
    
    if ($gatraCount == 0) {
        echo "No Gatra data found. Creating sample data...\n";
        
        // Buat data sample
        App\Models\Gatra::create([
            'gatra' => 'Kualitas Kerja',
            'bobot' => 20,
            'skor' => 85.5,
            'bobot_x_skor' => 1710.0
        ]);
        
        App\Models\Gatra::create([
            'gatra' => 'Ketepatan Waktu',
            'bobot' => 25,
            'skor' => 90.0,
            'bobot_x_skor' => 2250.0
        ]);
        
        App\Models\Gatra::create([
            'gatra' => 'Komunikasi',
            'bobot' => 15,
            'skor' => 78.5,
            'bobot_x_skor' => 1177.5
        ]);
        
        echo "✅ Sample Gatra data created successfully!\n";
    }
    
    // Tampilkan semua data Gatra
    $gatraData = App\Models\Gatra::all();
    echo "\nGatra Data:\n";
    foreach ($gatraData as $gatra) {
        echo "  ID: {$gatra->id}, Gatra: {$gatra->gatra}, Bobot: {$gatra->bobot}, Skor: {$gatra->skor}, Bobot x Skor: {$gatra->bobot_x_skor}\n";
    }
    
    echo "\n=== API ENDPOINT INFO ===\n";
    echo "GET /api/gatra\n";
    echo "Authorization: Bearer {token}\n";
    echo "Content-Type: application/json\n";
    
    echo "\n=== TESTING SUMMARY ===\n";
    echo "✅ Gatra model: Working\n";
    echo "✅ Sample data: Available (" . App\Models\Gatra::count() . " records)\n";
    echo "✅ API endpoint: /api/gatra (with auth)\n";
    echo "✅ Response format: JSON with success, message, and data fields\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "\n=== END TEST ===\n";
