<?php
require 'vendor/autoload.php';
$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== TESTING KLASIFIKASI TABLE ===\n";

try {
    // Test membuat data klasifikasi
    $klasifikasi = App\Models\Klasifikasi::create([
        'gatra' => 'Penampilan',
        'type' => 'Kategori A',
        'title' => 'Evaluasi Penampilan Karyawan',
        'api' => 'appearance_eval',
        'kode' => 'PEN001',
        'from' => 0.0,
        'to' => 100.0,
        'indeks' => 1
    ]);
    
    echo "✅ SUCCESS: Klasifikasi created with ID: " . $klasifikasi->id . "\n";
    echo "Data klasifikasi:\n";
    echo "  Gatra: " . $klasifikasi->gatra . "\n";
    echo "  Type: " . $klasifikasi->type . "\n";
    echo "  Title: " . $klasifikasi->title . "\n";
    echo "  API: " . $klasifikasi->api . "\n";
    echo "  Kode: " . $klasifikasi->kode . "\n";
    echo "  From: " . $klasifikasi->from . "\n";
    echo "  To: " . $klasifikasi->to . "\n";
    echo "  Indeks: " . $klasifikasi->indeks . "\n";
    
    // Test data count
    $count = App\Models\Klasifikasi::count();
    echo "\nTotal klasifikasi records: " . $count . "\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "\n=== TABLE STRUCTURE SUMMARY ===\n";
echo "Table: klasifikasi\n";
echo "Fields:\n";
echo "  - id (primary key, auto increment)\n";
echo "  - gatra (string)\n";
echo "  - type (string)\n";
echo "  - title (string)\n";
echo "  - api (string)\n";
echo "  - kode (string)\n";
echo "  - from (double)\n";
echo "  - to (double)\n";
echo "  - indeks (integer)\n";
echo "  - created_at (timestamp)\n";
echo "  - updated_at (timestamp)\n";

echo "\n=== END TEST ===\n";
