<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);

// Create a request to the klasifikasi index
$request = Illuminate\Http\Request::create('/admin/data-klasifikasi', 'GET');

try {
    $response = $kernel->handle($request);
    
    echo "=== Test Klasifikasi Index Page ===\n\n";
    echo "Status Code: " . $response->getStatusCode() . "\n";
    echo "Response Type: " . $response->headers->get('content-type') . "\n\n";
    
    if ($response->getStatusCode() == 200) {
        $content = $response->getContent();
        
        // Check if the page contains expected elements
        $checks = [
            'Update Semua Data' => strpos($content, 'Update Semua Data') !== false,
            'Detail Count column' => strpos($content, 'Detail Count') !== false,
            'data badge' => strpos($content, 'badge bg-info') !== false,
            'eye icon button' => strpos($content, 'bi-eye') !== false,
            'Detail modal' => strpos($content, 'detailModal') !== false,
        ];
        
        echo "Content Checks:\n";
        foreach ($checks as $check => $result) {
            echo "  - $check: " . ($result ? '✓ FOUND' : '✗ NOT FOUND') . "\n";
        }
        
        // Count data rows
        $dataRowsCount = substr_count($content, '<tr>') - 1; // subtract header row
        echo "\nEstimated data rows: $dataRowsCount\n";
        
        echo "\n=== Test Completed Successfully ===\n";
    } else {
        echo "Error: HTTP " . $response->getStatusCode() . "\n";
        echo "Content: " . substr($response->getContent(), 0, 500) . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
