<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Models\Klasifikasi;

echo "=== Test View Modifications ===\n\n";

try {
    // Test 1: Check if klasifikasi exists
    $klasifikasi = Klasifikasi::with('detailKlasifikasi')->first();
    
    if (!$klasifikasi) {
        echo "No klasifikasi found!\n";
        exit;
    }
    
    echo "1. Klasifikasi found: {$klasifikasi->gatra} (ID: {$klasifikasi->id})\n";
    echo "2. Detail count: {$klasifikasi->detailKlasifikasi->count()}\n\n";
    
    // Test 2: Check if view file contains the new elements
    $viewPath = 'resources/views/pages/data-klasifikasi/index.blade.php';
    $viewContent = file_get_contents($viewPath);
    
    echo "3. Checking view modifications:\n";
    
    $checks = [
        'Toggle button' => strpos($viewContent, 'toggleDetailBtn') !== false,
        'JavaScript function' => strpos($viewContent, 'function toggleDetailTable') !== false,
        'Hidden div' => strpos($viewContent, 'style="display: none;"') !== false,
        'Show Detail text' => strpos($viewContent, 'Show Detail') !== false,
        'Hide Detail text' => strpos($viewContent, 'Hide Detail') !== false,
        'Eye icon' => strpos($viewContent, 'bi-eye') !== false,
        'Eye-slash icon' => strpos($viewContent, 'bi-eye-slash') !== false,
    ];
    
    foreach ($checks as $check => $result) {
        echo "   - $check: " . ($result ? '✓ FOUND' : '✗ NOT FOUND') . "\n";
    }
    
    echo "\n4. Expected behavior:\n";
    echo "   - Detail table initially hidden\n";
    echo "   - 'Show Detail' button visible\n";
    echo "   - Click button toggles table visibility\n";
    echo "   - Button text changes between 'Show Detail' and 'Hide Detail'\n";
    echo "   - Button color changes between success (green) and warning (yellow)\n";
    echo "   - Icon changes between eye and eye-slash\n";
    
    echo "\n=== Test Completed Successfully ===\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
