import json

with open("template_coords.json", "r", encoding="utf-8") as f:
    data = json.load(f)

output = {}

for key in data:
    if key.endswith("_SAMPLE"):
        base_name = key.replace("_SAMPLE", "")
        blank_key = f"{base_name}_BLANK"
        output[blank_key] = {
            "coordinates": data[key]["coordinates"]
        }

# Simpan hasil ke template_coords.json lagi
with open("template_coords.json", "w", encoding="utf-8") as f:
    json.dump(output, f, indent=2)

print("✅ Semua koordinat berhasil disalin ke *_BLANK.")
