from flask import Flask, render_template, request, redirect, url_for, session
import json
import random

app = Flask(__name__)
app.secret_key = "quiz_secret_key"

# Load Questions
with open('questions.json') as f:
    QUESTIONS = json.load(f)

@app.route('/')
def index():
    session['score'] = 0
    session['current'] = 0
    random.shuffle(QUESTIONS)
    session['questions'] = QUESTIONS[:10]
    return render_template('index.html')

@app.route('/quiz', methods=['GET', 'POST'])
def quiz():
    if request.method == 'POST':
        selected = request.form.get('answer')
        correct_answer = session['questions'][session['current']]['answer']
        if selected == correct_answer:
            session['score'] += 1
        session['current'] += 1
        if session['current'] >= len(session['questions']):
            return redirect(url_for('result'))

    current_question = session['questions'][session['current']]
    return render_template('quiz.html', q=current_question, num=session['current']+1)

@app.route('/result')
def result():
    score = session.get('score', 0)
    return render_template('result.html', score=score)

if __name__ == '__main__':
    app.run(debug=True)
